Attribute VB_Name = "Module1"
Option Explicit

Private Const MAXPNAMELEN = 32 ' max product name length (including NULL)

Private Const MIXER_GETCONTROLDETAILSF_LISTTEXT = &H1&
Private Const MIXER_GETCONTROLDETAILSF_QUERYMASK = &HF&
Private Const MIXER_GETCONTROLDETAILSF_VALUE = &H0&

Private Const MIXER_GETLINECONTROLSF_ALL = &H0&
Private Const MIXER_GETLINECONTROLSF_ONEBYID = &H1&
Private Const MIXER_GETLINECONTROLSF_ONEBYTYPE = &H2&
Private Const MIXER_GETLINECONTROLSF_QUERYMASK = &HF&

Private Const MIXER_GETLINEINFOF_COMPONENTTYPE = &H3&
Private Const MIXER_GETLINEINFOF_DESTINATION = &H0&
Private Const MIXER_GETLINEINFOF_LINEID = &H2&
Private Const MIXER_GETLINEINFOF_QUERYMASK = &HF&
Private Const MIXER_GETLINEINFOF_SOURCE = &H1&
Private Const MIXER_GETLINEINFOF_TARGETTYPE = &H4&

Private Const MIXER_LONG_NAME_CHARS = 64
Private Const MIXER_SHORT_NAME_CHARS = 16

Private Const MIXER_OBJECTF_AUX = &H50000000
Private Const MIXER_OBJECTF_HANDLE = &H80000000
Private Const MIXER_OBJECTF_MIDIIN = &H40000000
Private Const MIXER_OBJECTF_MIDIOUT = &H30000000
Private Const MIXER_OBJECTF_MIXER = &H0&
Private Const MIXER_OBJECTF_WAVEIN = &H20000000
Private Const MIXER_OBJECTF_WAVEOUT = &H10000000
Private Const MIXER_OBJECTF_HMIDIIN = (MIXER_OBJECTF_HANDLE Or MIXER_OBJECTF_MIDIIN)
Private Const MIXER_OBJECTF_HMIDIOUT = (MIXER_OBJECTF_HANDLE Or MIXER_OBJECTF_MIDIOUT)
Private Const MIXER_OBJECTF_HMIXER = (MIXER_OBJECTF_HANDLE Or MIXER_OBJECTF_MIXER)
Private Const MIXER_OBJECTF_HWAVEIN = (MIXER_OBJECTF_HANDLE Or MIXER_OBJECTF_WAVEIN)
Private Const MIXER_OBJECTF_HWAVEOUT = (MIXER_OBJECTF_HANDLE Or MIXER_OBJECTF_WAVEOUT)

Private Const MIXER_SETCONTROLDETAILSF_CUSTOM = &H1&
Private Const MIXER_SETCONTROLDETAILSF_QUERYMASK = &HF&
Private Const MIXER_SETCONTROLDETAILSF_VALUE = &H0&

Private Const MIXERCONTROL_CONTROLF_DISABLED = &H80000000
Private Const MIXERCONTROL_CONTROLF_MULTIPLE = &H2&
Private Const MIXERCONTROL_CONTROLF_UNIFORM = &H1&

Private Const MIXERCONTROL_CT_CLASS_CUSTOM = &H0&
Private Const MIXERCONTROL_CT_CLASS_FADER = &H50000000
Private Const MIXERCONTROL_CT_CLASS_LIST = &H70000000
Private Const MIXERCONTROL_CT_CLASS_MASK = &HF0000000
Private Const MIXERCONTROL_CT_CLASS_METER = &H10000000
Private Const MIXERCONTROL_CT_CLASS_NUMBER = &H30000000
Private Const MIXERCONTROL_CT_CLASS_SLIDER = &H40000000
Private Const MIXERCONTROL_CT_CLASS_SWITCH = &H20000000
Private Const MIXERCONTROL_CT_CLASS_TIME = &H60000000
Private Const MIXERCONTROL_CT_SC_LIST_MULTIPLE = &H1000000
Private Const MIXERCONTROL_CT_SC_LIST_SINGLE = &H0&
Private Const MIXERCONTROL_CT_SC_METER_POLLED = &H0&
Private Const MIXERCONTROL_CT_SC_SWITCH_BOOLEAN = &H0&
Private Const MIXERCONTROL_CT_SC_SWITCH_BUTTON = &H1000000
Private Const MIXERCONTROL_CT_SC_TIME_MICROSECS = &H0&
Private Const MIXERCONTROL_CT_SC_TIME_MILLISECS = &H1000000
Private Const MIXERCONTROL_CT_SUBCLASS_MASK = &HF000000
Private Const MIXERCONTROL_CT_UNITS_BOOLEAN = &H10000
Private Const MIXERCONTROL_CT_UNITS_CUSTOM = &H0&
Private Const MIXERCONTROL_CT_UNITS_DECIBELS = &H40000 ' in 10ths
Private Const MIXERCONTROL_CT_UNITS_MASK = &HFF0000
Private Const MIXERCONTROL_CT_UNITS_PERCENT = &H50000 ' in 10ths
Private Const MIXERCONTROL_CT_UNITS_SIGNED = &H20000
Private Const MIXERCONTROL_CT_UNITS_UNSIGNED = &H30000
Private Const MIXERCONTROL_CONTROLTYPE_FADER = (MIXERCONTROL_CT_CLASS_FADER Or MIXERCONTROL_CT_UNITS_UNSIGNED)
Private Const MIXERCONTROL_CONTROLTYPE_SLIDER = (MIXERCONTROL_CT_CLASS_SLIDER Or MIXERCONTROL_CT_UNITS_SIGNED)
Private Const MIXERCONTROL_CONTROLTYPE_UNSIGNEDMETER = (MIXERCONTROL_CT_CLASS_METER Or MIXERCONTROL_CT_SC_METER_POLLED Or MIXERCONTROL_CT_UNITS_UNSIGNED)
Private Const MIXERCONTROL_CONTROLTYPE_SIGNEDMETER = (MIXERCONTROL_CT_CLASS_METER Or MIXERCONTROL_CT_SC_METER_POLLED Or MIXERCONTROL_CT_UNITS_SIGNED)
Private Const MIXERCONTROL_CONTROLTYPE_SINGLESELECT = (MIXERCONTROL_CT_CLASS_LIST Or MIXERCONTROL_CT_SC_LIST_SINGLE Or MIXERCONTROL_CT_UNITS_BOOLEAN)
Private Const MIXERCONTROL_CONTROLTYPE_MULTIPLESELECT = (MIXERCONTROL_CT_CLASS_LIST Or MIXERCONTROL_CT_SC_LIST_MULTIPLE Or MIXERCONTROL_CT_UNITS_BOOLEAN)
Private Const MIXERCONTROL_CONTROLTYPE_BASS = (MIXERCONTROL_CONTROLTYPE_FADER + 2)
Private Const MIXERCONTROL_CONTROLTYPE_BOOLEAN = (MIXERCONTROL_CT_CLASS_SWITCH Or MIXERCONTROL_CT_SC_SWITCH_BOOLEAN Or MIXERCONTROL_CT_UNITS_BOOLEAN)
Private Const MIXERCONTROL_CONTROLTYPE_BOOLEANMETER = (MIXERCONTROL_CT_CLASS_METER Or MIXERCONTROL_CT_SC_METER_POLLED Or MIXERCONTROL_CT_UNITS_BOOLEAN)
Private Const MIXERCONTROL_CONTROLTYPE_BUTTON = (MIXERCONTROL_CT_CLASS_SWITCH Or MIXERCONTROL_CT_SC_SWITCH_BUTTON Or MIXERCONTROL_CT_UNITS_BOOLEAN)
Private Const MIXERCONTROL_CONTROLTYPE_CUSTOM = (MIXERCONTROL_CT_CLASS_CUSTOM Or MIXERCONTROL_CT_UNITS_CUSTOM)
Private Const MIXERCONTROL_CONTROLTYPE_DECIBELS = (MIXERCONTROL_CT_CLASS_NUMBER Or MIXERCONTROL_CT_UNITS_DECIBELS)
Private Const MIXERCONTROL_CONTROLTYPE_EQUALIZER = (MIXERCONTROL_CONTROLTYPE_FADER + 4)
Private Const MIXERCONTROL_CONTROLTYPE_LOUDNESS = (MIXERCONTROL_CONTROLTYPE_BOOLEAN + 4)
Private Const MIXERCONTROL_CONTROLTYPE_MICROTIME = (MIXERCONTROL_CT_CLASS_TIME Or MIXERCONTROL_CT_SC_TIME_MICROSECS Or MIXERCONTROL_CT_UNITS_UNSIGNED)
Private Const MIXERCONTROL_CONTROLTYPE_MILLITIME = (MIXERCONTROL_CT_CLASS_TIME Or MIXERCONTROL_CT_SC_TIME_MILLISECS Or MIXERCONTROL_CT_UNITS_UNSIGNED)
Private Const MIXERCONTROL_CONTROLTYPE_MIXER = (MIXERCONTROL_CONTROLTYPE_MULTIPLESELECT + 1)
Private Const MIXERCONTROL_CONTROLTYPE_MONO = (MIXERCONTROL_CONTROLTYPE_BOOLEAN + 3)
Private Const MIXERCONTROL_CONTROLTYPE_MUTE = (MIXERCONTROL_CONTROLTYPE_BOOLEAN + 2)
Private Const MIXERCONTROL_CONTROLTYPE_MUX = (MIXERCONTROL_CONTROLTYPE_SINGLESELECT + 1)
Private Const MIXERCONTROL_CONTROLTYPE_ONOFF = (MIXERCONTROL_CONTROLTYPE_BOOLEAN + 1)
Private Const MIXERCONTROL_CONTROLTYPE_PAN = (MIXERCONTROL_CONTROLTYPE_SLIDER + 1)
Private Const MIXERCONTROL_CONTROLTYPE_PEAKMETER = (MIXERCONTROL_CONTROLTYPE_SIGNEDMETER + 1)
Private Const MIXERCONTROL_CONTROLTYPE_PERCENT = (MIXERCONTROL_CT_CLASS_NUMBER Or MIXERCONTROL_CT_UNITS_PERCENT)
Private Const MIXERCONTROL_CONTROLTYPE_QSOUNDPAN = (MIXERCONTROL_CONTROLTYPE_SLIDER + 2)
Private Const MIXERCONTROL_CONTROLTYPE_SIGNED = (MIXERCONTROL_CT_CLASS_NUMBER Or MIXERCONTROL_CT_UNITS_SIGNED)
Private Const MIXERCONTROL_CONTROLTYPE_STEREOENH = (MIXERCONTROL_CONTROLTYPE_BOOLEAN + 5)
Private Const MIXERCONTROL_CONTROLTYPE_TREBLE = (MIXERCONTROL_CONTROLTYPE_FADER + 3)
Private Const MIXERCONTROL_CONTROLTYPE_UNSIGNED = (MIXERCONTROL_CT_CLASS_NUMBER Or MIXERCONTROL_CT_UNITS_UNSIGNED)
Private Const MIXERCONTROL_CONTROLTYPE_VOLUME = (MIXERCONTROL_CONTROLTYPE_FADER + 1)

Private Const MIXERLINE_COMPONENTTYPE_SRC_FIRST = &H1000&
Private Const MIXERLINE_COMPONENTTYPE_DST_FIRST = &H0&
Private Const MIXERLINE_COMPONENTTYPE_DST_DIGITAL = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 1)
Private Const MIXERLINE_COMPONENTTYPE_DST_HEADPHONES = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 5)
Private Const MIXERLINE_COMPONENTTYPE_DST_LAST = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 8)
Private Const MIXERLINE_COMPONENTTYPE_DST_LINE = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 2)
Private Const MIXERLINE_COMPONENTTYPE_DST_MONITOR = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 3)
Private Const MIXERLINE_COMPONENTTYPE_DST_SPEAKERS = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 4)
Private Const MIXERLINE_COMPONENTTYPE_DST_TELEPHONE = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 6)
Private Const MIXERLINE_COMPONENTTYPE_DST_UNDEFINED = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 0)
Private Const MIXERLINE_COMPONENTTYPE_DST_VOICEIN = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 8)
Private Const MIXERLINE_COMPONENTTYPE_DST_WAVEIN = (MIXERLINE_COMPONENTTYPE_DST_FIRST + 7)
Private Const MIXERLINE_COMPONENTTYPE_SRC_ANALOG = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 10)
Private Const MIXERLINE_COMPONENTTYPE_SRC_AUXILIARY = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 9)
Private Const MIXERLINE_COMPONENTTYPE_SRC_COMPACTDISC = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 5)
Private Const MIXERLINE_COMPONENTTYPE_SRC_DIGITAL = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 1)
Private Const MIXERLINE_COMPONENTTYPE_SRC_LAST = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 10)
Private Const MIXERLINE_COMPONENTTYPE_SRC_LINE = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 2)
Private Const MIXERLINE_COMPONENTTYPE_SRC_MICROPHONE = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 3)
Private Const MIXERLINE_COMPONENTTYPE_SRC_PCSPEAKER = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 7)
Private Const MIXERLINE_COMPONENTTYPE_SRC_SYNTHESIZER = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 4)
Private Const MIXERLINE_COMPONENTTYPE_SRC_TELEPHONE = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 6)
Private Const MIXERLINE_COMPONENTTYPE_SRC_UNDEFINED = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 0)
Private Const MIXERLINE_COMPONENTTYPE_SRC_WAVEOUT = (MIXERLINE_COMPONENTTYPE_SRC_FIRST + 8)
Private Const MIXERLINE_LINEF_ACTIVE = &H1&
Private Const MIXERLINE_LINEF_DISCONNECTED = &H8000&
Private Const MIXERLINE_LINEF_SOURCE = &H80000000
Private Const MIXERLINE_TARGETTYPE_AUX = 5
Private Const MIXERLINE_TARGETTYPE_MIDIIN = 4
Private Const MIXERLINE_TARGETTYPE_MIDIOUT = 3
Private Const MIXERLINE_TARGETTYPE_UNDEFINED = 0
Private Const MIXERLINE_TARGETTYPE_WAVEIN = 2
Private Const MIXERLINE_TARGETTYPE_WAVEOUT = 1
Private Const MIXERR_BASE = 1024
Private Const MIXERR_INVALCONTROL = (MIXERR_BASE + 1)
Private Const MIXERR_INVALLINE = (MIXERR_BASE + 0)
Private Const MIXERR_INVALVALUE = (MIXERR_BASE + 2)
Private Const MIXERR_LASTERROR = (MIXERR_BASE + 2)

Private Type MIXERCONTROLDETAILS_LISTTEXT
    dwParam1 As Long
    dwParam2 As Long
    szName As Long ' String * MIXER_LONG_NAME_CHARS
End Type

Private Type MIXERCAPS
    wMid As Integer ' manufacturer id
    wPid As Integer ' product id
    vDriverVersion As Long ' version of the driver
    szPname As String * MAXPNAMELEN ' product name
    fdwSupport As Long ' misc. support bits
    cDestinations As Long ' count of destinations
End Type
Private Type MIXERCONTROL
    cbStruct As Long ' size in Byte of MIXERCONTROL
    dwControlID As Long ' unique control id for mixer device
    dwControlType As Long ' MIXERCONTROL_CONTROLTYPE_xxx
    fdwControl As Long ' MIXERCONTROL_CONTROLF_xxx
    cMultipleItems As Long ' if MIXERCONTROL_CONTROLF_MULTIPLE set
    szShortName(MIXER_SHORT_NAME_CHARS / 2 - 1) As Integer
    szName(MIXER_LONG_NAME_CHARS / 2 - 1) As Integer
    Bounds(5) As Long ' Longest member of the Bounds union
    Metrics(5) As Long ' Longest member of the Metrics union
End Type

Private Type MIXERCONTROLDETAILS
    cbStruct As Long ' size in Byte of MIXERCONTROLDETAILS
    dwControlID As Long ' control id to get/set details on
    cChannels As Long ' number of channels in paDetails array
    item As Long ' hwndOwner or cMultipleItems
    cbDetails As Long ' size of _one_ details_XX struct
    paDetails As Long ' pointer to array of details_XX structs
End Type

Private Type Target ' for use in MIXERLINE and others (embedded structure)
    dwType As Long ' MIXERLINE_TARGETTYPE_xxxx
    dwDeviceID As Long ' target device ID of device type
    wMid As Integer ' of target device
    wPid As Integer ' "
    vDriverVersion As Long ' "
    szPname As String * MAXPNAMELEN
End Type
Private Type MIXERLINE
    cbStruct As Long ' size of MIXERLINE structure
    dwDestination As Long ' zero based destination index
    dwSource As Long ' zero based source index (if source)
    dwLineID As Long ' unique line id for mixer device
    fdwLine As Long ' state/information about line
    dwUser As Long ' driver specific information
    dwComponentType As Long ' component type line connects to
    cChannels As Long ' number of channels line supports
    cConnections As Long ' number of connections (possible)
    cControls As Long ' number of controls at this line
    szShortName As String * MIXER_SHORT_NAME_CHARS
    szName As String * MIXER_LONG_NAME_CHARS
    tTarget As Target
End Type
Private Type MIXERLINECONTROLS
    cbStruct As Long ' size in Byte of MIXERLINECONTROLS
    dwLineID As Long ' line id (from MIXERLINE.dwLineID)
    ' MIXER_GETLINECONTROLSF_ONEBYID or
    dwControl As Long ' MIXER_GETLINECONTROLSF_ONEBYTYPE
    cControls As Long ' count of controls pmxctrl points to
    cbmxctrl As Long ' size in Byte of _one_ MIXERCONTROL
    pamxctrl As Long ' pointer to first MIXERCONTROL array
End Type

Private Declare Function mixerClose Lib "winmm.dll" (ByVal hmx As Long) As Long
Private Declare Function mixerGetControlDetails Lib "winmm.dll" Alias "mixerGetControlDetailsA" (ByVal hmxobj As Long, pmxcd As MIXERCONTROLDETAILS, ByVal fdwDetails As Long) As Long
Private Declare Function mixerGetDevCaps Lib "winmm.dll" Alias "mixerGetDevCapsA" (ByVal uMxId As Long, ByVal pmxcaps As MIXERCAPS, ByVal cbmxcaps As Long) As Long
Private Declare Function mixerGetID Lib "winmm.dll" (ByVal hmxobj As Long, pumxID As Long, ByVal fdwId As Long) As Long
Private Declare Function mixerGetLineControls Lib "winmm.dll" Alias "mixerGetLineControlsA" (ByVal hmxobj As Long, pmxlc As MIXERLINECONTROLS, ByVal fdwControls As Long) As Long
Private Declare Function mixerGetLineInfo Lib "winmm.dll" Alias "mixerGetLineInfoA" (ByVal hmxobj As Long, pmxl As MIXERLINE, ByVal fdwInfo As Long) As Long
Private Declare Function mixerGetNumDevs Lib "winmm.dll" () As Long
Private Declare Function mixerMessage Lib "winmm.dll" (ByVal hmx As Long, ByVal uMsg As Long, ByVal dwParam1 As Long, ByVal dwParam2 As Long) As Long
Private Declare Function mixerOpen Lib "winmm.dll" (phmx As Long, ByVal uMxId As Long, ByVal dwCallback As Long, ByVal dwInstance As Long, ByVal fdwOpen As Long) As Long
Private Declare Function mixerSetControlDetails Lib "winmm.dll" (ByVal hmxobj As Long, pmxcd As MIXERCONTROLDETAILS, ByVal fdwDetails As Long) As Long
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (Destination As Any, ByVal Source As Long, ByVal length As Long)


Public Type MIXERCONTROLDETAILS_UNSIGNED
    dwValue As Long ' value of the control
End Type

Public Function SelectRecInput(DeviceID As Long, InputDevice As Long, InputLevel As Long, Optional sError As String) As Boolean
Dim pmxl As MIXERLINE, pmxlc As MIXERLINECONTROLS, pmxc As MIXERCONTROL, pmxcd As MIXERCONTROLDETAILS, mcdlt() As MIXERCONTROLDETAILS_LISTTEXT, mcdb() As Long
Dim rc As Long, Index As Long, pmxcdu As MIXERCONTROLDETAILS_UNSIGNED
On Error GoTo Exception
'Get WaveIn Destination Line ID
Let pmxl.cbStruct = Len(pmxl)
Let pmxl.dwComponentType = MIXERLINE_COMPONENTTYPE_DST_WAVEIN
Let rc = mixerGetLineInfo(DeviceID, pmxl, MIXER_GETLINEINFOF_COMPONENTTYPE)
If rc <> 0 Then GoTo Exception 'Error Trap

'Get Control ID with MIXER
Let pmxlc.cbStruct = Len(pmxlc)
Let pmxlc.dwLineID = pmxl.dwLineID
Let pmxlc.dwControl = MIXERCONTROL_CONTROLTYPE_MIXER
Let pmxlc.cControls = pmxl.cControls
Let pmxlc.cbmxctrl = Len(pmxc)
Let pmxlc.pamxctrl = VarPtr(pmxc)
Let rc = mixerGetLineControls(DeviceID, pmxlc, MIXER_GETLINECONTROLSF_ONEBYTYPE)
If rc <> 0 Then
'Get Control ID
Let pmxlc.dwControl = MIXERCONTROL_CONTROLTYPE_MUX
Let rc = mixerGetLineControls(DeviceID, pmxlc, MIXER_GETLINECONTROLSF_ONEBYTYPE)
If rc <> 0 Then GoTo Exception 'Error Trap
End If

'Get Control Details
ReDim mcdlt(pmxc.cMultipleItems - 1)
Let pmxcd.cbStruct = Len(pmxcd)
Let pmxcd.cChannels = 1
Let pmxcd.dwControlID = pmxc.dwControlID
Let pmxcd.item = pmxc.cMultipleItems
Let pmxcd.cbDetails = Len(mcdlt(0))
Let pmxcd.paDetails = VarPtr(mcdlt(0))
Let rc = mixerGetControlDetails(DeviceID, pmxcd, MIXER_GETCONTROLDETAILSF_LISTTEXT)
If rc <> 0 Then GoTo Exception 'Error Trap

For Index = LBound(mcdlt) To UBound(mcdlt)
pmxl.dwLineID = mcdlt(Index).dwParam1
Let rc = mixerGetLineInfo(DeviceID, pmxl, MIXER_GETLINEINFOF_LINEID)
If rc <> 0 Then GoTo Exception 'Error Trap
If InputDevice = 0 Then
If pmxl.dwComponentType = MIXERLINE_COMPONENTTYPE_SRC_MICROPHONE Then
Exit For
End If
Else
If pmxl.dwComponentType = MIXERLINE_COMPONENTTYPE_SRC_LINE Then
Exit For
End If
End If
Next
If Index > UBound(mcdlt) Then GoTo Exception

'Get Control Values
ReDim mcdb(pmxc.cMultipleItems - 1)
Let pmxcd.cbDetails = Len(mcdb(0))
Let pmxcd.paDetails = VarPtr(mcdb(0))
'Set device as default
Let mcdb(Index) = 1
Let rc = mixerSetControlDetails(DeviceID, pmxcd, MIXER_SETCONTROLDETAILSF_VALUE)
If rc <> 0 Then GoTo Exception 'Error Trap
'================================
'----------Esto es para el volumen
'==================================
'Get Control ID with MIXER
Let pmxlc.dwLineID = pmxl.dwLineID
Let pmxlc.dwControl = MIXERCONTROL_CONTROLTYPE_VOLUME
Let pmxlc.cControls = pmxl.cControls
Let pmxlc.cbmxctrl = Len(pmxc)
Let pmxlc.pamxctrl = VarPtr(pmxc)
Let rc = mixerGetLineControls(DeviceID, pmxlc, MIXER_GETLINECONTROLSF_ONEBYTYPE)
If rc <> 0 Then GoTo Exception 'Error Trap

'Get Control Details
Let pmxcd.cbStruct = Len(pmxcd)
Let pmxcd.cChannels = 1
Let pmxcd.dwControlID = pmxc.dwControlID
Let pmxcd.item = pmxc.cMultipleItems
Let pmxcd.cbDetails = Len(pmxcdu)
Let pmxcd.paDetails = VarPtr(pmxcdu)
Let rc = mixerGetControlDetails(DeviceID, pmxcd, MIXER_GETCONTROLDETAILSF_VALUE)
If rc <> 0 Then GoTo Exception 'Error Trap
'Debug.Print "Actual Input Level=" & pmxcdu.dwValue
'Set new input level
pmxcdu.dwValue = InputLevel
Let rc = mixerSetControlDetails(DeviceID, pmxcd, MIXER_SETCONTROLDETAILSF_VALUE)
If rc <> 0 Then GoTo Exception 'Error Trap

Let SelectRecInput = True
Exit Function
Exception:
Debug.Print "ERROR"
End Function

